<?php
/**
 * Template part for displaying single team post
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package panthar
 */

$panthar = panthar();
$panthar_meta = get_post_meta(get_the_ID(), 'panthar_team_options', true);

$img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
$img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'medium', false) : '';
$img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
$img_alt = $img_id ? get_post_meta($img_id, '_wp_attachment_image_alt', true) : '';
$designation = isset($panthar_meta['designation']) && !empty($panthar_meta['designation']) ? $panthar_meta['designation'] : '';
$description = isset($panthar_meta['description']) && !empty($panthar_meta['description']) ? $panthar_meta['description'] : '';
$experience_icon = isset($panthar_meta['experience-icon']) && !empty($panthar_meta['experience-icon']) ? $panthar_meta['experience-icon'] : '';
$experience = isset($panthar_meta['experience']) && !empty($panthar_meta['experience']) ? $panthar_meta['experience'] : '';
$team_info = isset($panthar_meta['contact-info']) && !empty($panthar_meta['contact-info']) ? $panthar_meta['contact-info'] : '';
$social_icons = isset($panthar_meta['social-icons']) && !empty($panthar_meta['social-icons']) ? $panthar_meta['social-icons'] : '';
$team_icon = is_rtl() ? 'icomoon-bullet-left' : 'icomoon-bulle';
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('panthar-details-content-area'); ?>>
    <div class="entry-content">
        <div class="team-area-wrap">
            <div class="row">
                <?php if(!empty($img_url)) : ?>
                    <div class="col-lg-4">
                        <div class="img-wrapper">
                            <img class="w-100" src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr($img_alt); ?>">
                        </div>
                    </div>
                <?php endif; ?>
                <?php 
                    $pl_lg_5 = 'col-lg-12 pl-lg-4';
                    if(!empty($img_url)) : 
                    $pl_lg_5 = 'col-lg-8 pl-lg-5';
                    endif; 
                ?>
                <div class="<?php echo esc_attr($pl_lg_5); ?>">
                    <div class="details-inner">
                        <p class="designation"><?php echo esc_html($designation); ?> <i class="<?php echo esc_attr($team_icon);?>"></i></p>
                        <h2 class="title"><?php echo esc_html(the_title()); ?></h2>
                        <p class="content"><?php echo esc_html($description); ?></p>
                        <div class="contact-info">
                            <div class="row">
                                <div class="col-lg-7">
                                    <div class="team-contact-list">
                                        <h4><?php echo esc_html__('CONTACT', 'panthar'); ?></h4>
                                        <ul>
                                            <?php
                                            if (!empty($team_info)) {
                                                foreach ($team_info as $info) {
                                                    printf('<li><i class="%2$s"></i>%1$s</li>', $info['title'], $info['icon']);
                                                }
                                            }
                                            ?>
                                        </ul>
                                    </div>
                                    <div class="team-social-list">
                                        <ul>
                                            <li><i class="fa fa-share-alt"></i></li>
                                            <?php
                                            if (!empty($social_icons)) {
                                                foreach ($social_icons as $s_info) {
                                                    printf('<li><a href="%2$s">%1$s</a></li>', $s_info['title'], $s_info['url']);
                                                }
                                            }
                                            ?>
                                        </ul>
                                    </div>
                                </div>
                                <?php if(!empty($experience)){ ?>
                                    <div class="col-lg-5">
                                        <div class="media">
                                            <div class="media-left">
                                                <i class="<?php echo esc_attr($experience_icon); ?>"></i>
                                            </div>
                                            <div class="media-body align-self-center">
                                                <p><?php echo esc_html($experience); ?></p>
                                            </div>
                                        </div> 
                                    </div>
                                <?php } ?>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        the_content();
        $panthar->link_pages();
        ?>
    </div>
</article><!-- #post-<?php the_ID(); ?> -->
