<?php
/**
 * Template part for displaying single package post
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package panthar
 */

$panthar = panthar();
$panthar_meta = get_post_meta(get_the_ID(), 'panthar_service_options', true);
$description = isset($panthar_meta['description']) && !empty($panthar_meta['description']) ? $panthar_meta['description'] : '';

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('service-details-item'); ?>>
    <div class="row">
        <div class="col-lg-8">
            <div class="entry-content">
                <div class="service-content-details">
                    <?php
                    if (has_post_thumbnail()) :
                        get_template_part('template-parts/content/thumbnail-classic');
                    endif;
                    ?>
                    <p class="content"><?php echo esc_html($description); ?></p>
                </div>
                
                <?php
                the_content();
                $panthar->link_pages();
                ?>
            </div>
        </div>
        <div class="col-lg-4">
            <aside id="secondary" class="widget-area service-widget">
                <?php dynamic_sidebar( 'service-sidebar' ); ?>
            </aside><!-- #secondary -->
        </div>
    </div>

    
</article><!-- #post-<?php the_ID(); ?> -->