<?php
/**
 * Theme Metabox Options
 * @package panthar
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {

    $allowed_html = panthar()->kses_allowed_html(array('mark'));

    $prefix = 'panthar';

    /*-------------------------------------
        Post Format Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_post_video_options', array(
        'title' => esc_html__('Video Post Format Options', 'panthar'),
        'post_type' => 'post',
        'post_formats' => 'video'
    ));
    CSF::createSection($prefix . '_post_video_options', array(
        'fields' => array(
            array(
                'id' => 'video_url',
                'type' => 'text',
                'title' => esc_html__('Enter Video URL', 'panthar'),
                'desc' => wp_kses(__('enter <mark>video url</mark> to show in frontend', 'panthar'), $allowed_html)
            )
        )
    ));
    CSF::createMetabox($prefix . '_post_gallery_options', array(
        'title' => esc_html__('Gallery Post Format Options', 'panthar'),
        'post_type' => 'post',
        'post_formats' => 'gallery'
    ));
    CSF::createSection($prefix . '_post_gallery_options', array(
        'fields' => array(
            array(
                'id' => 'gallery_images',
                'type' => 'gallery',
                'title' => esc_html__('Select Gallery Photos', 'panthar'),
                'desc' => wp_kses(__('select <mark>gallery photos</mark> to show in frontend', 'panthar'), $allowed_html)
            )
        )
    ));

    /*-------------------------------------
      Page Container Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_page_container_options', array(
        'title' => esc_html__('Page Options', 'panthar'),
        'post_type' => array('page'),
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Layout & Colors', 'panthar'),
        'icon' => 'fa fa-columns',
        'fields' => Panthar_Group_Fields::page_layout()
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Header Footer & Breadcrumb', 'panthar'),
        'icon' => 'fa fa-header',
        'fields' => Panthar_Group_Fields::Page_Container_Options('header_options')
    ));
    CSF::createSection($prefix . '_page_container_options', array(
        'title' => esc_html__('Width & Padding', 'panthar'),
        'icon' => 'fa fa-file-o',
        'fields' => Panthar_Group_Fields::Page_Container_Options('container_options')
    ));
    //	Service Meta Box
    CSF::createMetabox($prefix . '_service_options', array(
        'title' => esc_html__('Service Options', 'panthar'),
        'post_type' => 'service',
    ));
    CSF::createSection($prefix . '_service_options', array(
        'fields' => array(
            array(
                'id' => 'description',
                'type' => 'textarea',
                'title' => esc_html__('Add description', 'panthar'),
                'desc' => wp_kses(__('Please Add Your description', 'panthar'), $allowed_html)
            ),
            array(
                'id' => 'brochures_file',
                'type' => 'upload',
                'title' => esc_html__('Brochures File', 'panthar'),
                'desc' => wp_kses(__('Select Your Brochures File', 'panthar'), $allowed_html)
            ),
            array(
                'id' => 'company_details_file',
                'type' => 'upload',
                'title' => esc_html__('Company Details File', 'panthar'),
                'desc' => wp_kses(__('Select Your Company Details File', 'panthar'), $allowed_html)
            ),
        )
    ));

    /*-------------------------------------
     Team Options
    -------------------------------------*/
    CSF::createMetabox($prefix . '_team_options', array(
        'title' => esc_html__('Team Options', 'panthar'),
        'post_type' => array('team'),
        'priority' => 'high'
    ));
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Team Info', 'panthar'),
        'id' => 'panthar-info',
        'fields' => array(
            array(
                'id' => 'designation',
                'type' => 'text',
                'title' => esc_html__('Designation', 'panthar'),
            ),
            array(
                'id' => 'description',
                'type' => 'textarea',
                'title' => esc_html__('Description', 'panthar'),
            ),
            array(
                'id' => 'experience-icon',
                'type' => 'icon',
                'title' => esc_html__('experience Icon', 'panthar')
            ),
            array(
                'id' => 'experience',
                'type' => 'textarea',
                'title' => esc_html__('Experience', 'panthar'),
            ),
        )
    ));
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Contact Info', 'panthar'),
        'id' => 'panthar-info',
        'fields' => array(
            array(
                'id' => 'contact-info',
                'type' => 'repeater',
                'title' => esc_html__('Contact Info', 'panthar'),
                'fields' => array(
                    array(
                        'id' => 'icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'panthar')
                    ),
                    array(
                        'id' => 'title',
                        'type' => 'text',
                        'title' => esc_html__('Title', 'panthar')
                    ),
                ),
            ),
        )
    ));
    CSF::createSection($prefix . '_team_options', array(
        'title' => esc_html__('Social Info', 'panthar'),
        'id' => 'social-info',
        'fields' => array(
            array(
                'id' => 'social-icons',
                'type' => 'repeater',
                'title' => esc_html__('Social Info', 'panthar'),
                'fields' => array(

                    array(
                        'id' => 'title',
                        'type' => 'text',
                        'title' => esc_html__('Title', 'panthar')
                    ),
                    array(
                        'id' => 'url',
                        'type' => 'text',
                        'title' => esc_html__('URL', 'panthar')
                    ),

                ),
            ),
        )
    ));

    //	Deals Meta Box
    CSF::createMetabox($prefix . '_case_study_options', array(
        'title' => esc_html__('Case Study Options', 'panthar'),
        'post_type' => 'case-study',
    ));
    CSF::createSection($prefix . '_case_study_options', array(
        'fields' => array(
            array(
                'id' => 'description',
                'type' => 'textarea',
                'title' => esc_html__('Add description', 'panthar'),
                'desc' => wp_kses(__('Please Add Your description', 'panthar'), $allowed_html)
            ),
        )
    ));

    //	Packages Meta Box
    CSF::createMetabox($prefix . '_packages_options', array(
        'title' => esc_html__('Packages Options', 'panthar'),
        'post_type' => 'packages',
    ));
    CSF::createSection($prefix . '_packages_options', array(
        'fields' => array(
            array(
                'id' => 'packages_duration_option',
                'type' => 'text',
                'title' => esc_html__('Packages Duration', 'panthar'),
                'default' => esc_html__('2 hours 25 min', 'panthar'),
            ),
            array(
                'id' => 'packages_price_option',
                'type' => 'text',
                'title' => esc_html__('Packages Price', 'panthar'),
                'default' => esc_html__('$115.00', 'panthar'),
            ),
            array(
                'id' => 'packages_date_option',
                'type' => 'text',
                'title' => esc_html__('Packages Date', 'panthar'),
                'default' => esc_html__('Thursday, Nov 4, 2021', 'panthar'),
            ),
            array(
                'id' => 'packages_number_option',
                'type' => 'text',
                'title' => esc_html__('Packages Person Number', 'panthar'),
            )
        )
    ));
    
    //	Courses Meta Box
    CSF::createMetabox($prefix.'_courses_options',array(
        'title' => esc_html__('Courses Options','panthar'),
        'post_type' => 'courses',
    ));

    CSF::createSection($prefix . '_courses_options', array(
        'title' => esc_html__('Social Info', 'panthar'),
        'id' => 'social-info',
        'fields' => array(
            array(
                'id' => 'course_price_option',
                'type' => 'text',
                'title' => esc_html__('Course Price', 'panthar'),
                'default' => esc_html__('$65.00', 'panthar'),
            ),
            array(
                'id' => 'course_start_date_option',
                'type' => 'text',
                'title' => esc_html__('Start From', 'panthar'),
                'default' => esc_html__('Thursday, Nov 4, 2022', 'panthar'),
            ),
            array(
                'id' => 'study-option',
                'type' => 'repeater',
                'title' => esc_html__('Study Options', 'panthar'),
                'fields' => array(

                    array(
                        'id' => 'qualification',
                        'type' => 'text',
                        'title' => esc_html__('Qualification', 'panthar'),
                        'default' => esc_html__('Bachelor of Aviation (Hons)', 'panthar'),
                    ),
                    array(
                        'id' => 'length',
                        'type' => 'text',
                        'title' => esc_html__('Length', 'panthar'),
                        'default' => esc_html__('9 months full time', 'panthar'),
                    ),
                    array(
                        'id' => 'code',
                        'type' => 'text',
                        'title' => esc_html__('Code', 'panthar'),
                        'default' => esc_html__('ba1x', 'panthar'),
                    ),
                ),
            ),
            array(
                'id' => 'course_module_option',
                'type' => 'text',
                'title' => esc_html__('Course Module Title', 'panthar'),
                'default' => esc_html__('Download full course Module', 'panthar'),
            ),
            array(
                'id' => 'course_module_button_title',
                'type' => 'text',
                'title' => esc_html__('Course Module Button Title', 'panthar'),
                'default' => esc_html__('Download', 'panthar'),
            ),
            array(
                'id' => 'course_module_button_url',
                'type' => 'text',
                'title' => esc_html__('Course Module Button URL', 'panthar'),
                'default' => esc_html__('#', 'panthar'),
            ),
        )
    ));
}//endif