<?php
/**
 * Theme Social Share Widget
 * @package Panthar
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('panthar_social_share_widget', array(
        'title' => esc_html__('Panthar: Social Share', 'panthar-core'),
        'classname' => 'panthar-social-share-about',
        'description' => esc_html__('Display Social Share widget', 'panthar-core'),
        'fields' => array(
            array(
                'id' => 'heading',
                'type' => 'text',
                'title' => esc_html__('Enter Your Header Title', 'panthar-core'),
                'default' => esc_html__('Never Miss News', 'panthar-core')
            ),
            array(
                'id' => 'panthar-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Icon', 'panthar-core'),
                'fields' => array(
                    array(
                        'id' => 'panthar-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'panthar-core'),
                        'default' => 'fab fa-facebook'
                    ),
                    array(
                        'id' => 'panthar-social-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Ulr', 'panthar-core'),
                        'default' => '#'
                    ),
                ),
            ),
        )
    ));


    if (!function_exists('panthar_social_share_widget')) {
        function panthar_social_share_widget($args, $instance)
        {

            echo $args['before_widget'];
            

            $heading_title = $instance['heading'] ?? '';
            $socialIcon = is_array($instance['panthar-social-icon-repeater']) && !empty($instance['panthar-social-icon-repeater']) ? $instance['panthar-social-icon-repeater'] : [];


            ?>
            <div class="social-share-widget">
                <h4 class="widget-headline"><?php echo esc_html($heading_title); ?></h4>
                <ul class="social-icon style-03">
                    <?php
                    foreach ($socialIcon as $icon) {
                        printf('<li><a href="%2$s"><i class="%1$s"></i></a></li>', esc_html($icon['panthar-social-icon']), esc_url($icon['panthar-social-text']));
                    };
                    ?>
                </ul>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>