<?php
/*
Plugin Name: Panthar Core
Plugin URI: https://themeforest.net/user/themeim/portfolio
Description: Plugin to contain short codes and custom post types of the Panthar theme.
Author: Themeim
Author URI: https://themeim.com/
Version: 1.0.2
Text Domain: panthar-core
*/


/**
 * If this file is called directly, abort.
 * @package panthar
 * @since 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Plugin directory path
 * @package panthar
 * @since 1.0.0
 */
define( 'PANTHAR_CORE_ROOT_PATH', plugin_dir_path( __FILE__ ) );
define( 'PANTHAR_CORE_ROOT_URL', plugin_dir_url( __FILE__ ) );
define( 'PANTHAR_CORE_SELF_PATH', 'panthar-core/panthar-core.php' );
define( 'PANTHAR_CORE_VERSION', '1.0.0' );
define( 'PANTHAR_CORE_INC', PANTHAR_CORE_ROOT_PATH .'/inc');
define( 'PANTHAR_CORE_LIB', PANTHAR_CORE_ROOT_PATH .'/lib');
define( 'PANTHAR_CORE_ELEMENTOR', PANTHAR_CORE_ROOT_PATH .'/elementor');
define( 'PANTHAR_CORE_DEMO_IMPORT', PANTHAR_CORE_ROOT_PATH .'/demo-import');
define( 'PANTHAR_CORE_ADMIN', PANTHAR_CORE_ROOT_PATH .'/admin');
define( 'PANTHAR_CORE_ADMIN_ASSETS', PANTHAR_CORE_ROOT_URL .'admin/assets');
define( 'PANTHAR_CORE_WP_WIDGETS', PANTHAR_CORE_ROOT_PATH .'/wp-widgets');
define( 'PANTHAR_CORE_ASSETS', PANTHAR_CORE_ROOT_URL .'assets/');
define( 'PANTHAR_CORE_CSS', PANTHAR_CORE_ASSETS .'css');
define( 'PANTHAR_CORE_JS', PANTHAR_CORE_ASSETS .'js');
define( 'PANTHAR_CORE_IMG', PANTHAR_CORE_ASSETS .'img');


/**
 * Load additional helpers functions
 * @package panthar
 * @since 1.0.0
 */
if (!function_exists('panthar_core')){
	require_once PANTHAR_CORE_INC .'/theme-core-helper-functions.php';
	if (!function_exists('panthar_core')){
		function panthar_core(){
			return class_exists('Panthar_Core_Helper_Functions') ? new Panthar_Core_Helper_Functions() : false;
		}
	}
}
//ob flash
remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );


/**
 * Load Codestar Framework Functions
 * @package panthar
 * @since 1.0.0
 */
if ( !panthar_core()->is_panthar_active()) {
	if ( file_exists( PANTHAR_CORE_ROOT_PATH . '/inc/csf-functions.php' ) ) {
		require_once PANTHAR_CORE_ROOT_PATH . '/inc/csf-functions.php';
	}
}



/**
 * Core Plugin Init
 * @package panthar
 * @since 1.0.0
 */
if ( file_exists( PANTHAR_CORE_ROOT_PATH . '/inc/theme-core-init.php' ) ) {
	require_once PANTHAR_CORE_ROOT_PATH . '/inc/theme-core-init.php';
}
